/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.api.behaviour.movement;

import com.simibubi.create.api.registry.SimpleRegistry;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ActorVisual;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_4597;

public interface MovementBehaviour {
    public static final SimpleRegistry<class_2248, MovementBehaviour> REGISTRY = SimpleRegistry.create();

    public static <B extends class_2248> NonNullConsumer<? super B> movementBehaviour(MovementBehaviour behaviour) {
        return b -> REGISTRY.register((class_2248)b, behaviour);
    }

    default public boolean isActive(MovementContext context) {
        return !context.disabled;
    }

    default public void tick(MovementContext context) {
    }

    default public void startMoving(MovementContext context) {
    }

    default public void visitNewPosition(MovementContext context, class_2338 pos) {
    }

    default public class_243 getActiveAreaOffset(MovementContext context) {
        return class_243.field_1353;
    }

    @Nullable
    default public class_1799 canBeDisabledVia(MovementContext context) {
        class_2248 block = context.state.method_26204();
        if (block == null) {
            return null;
        }
        return new class_1799((class_1935)block);
    }

    default public void onDisabledByControls(MovementContext context) {
        this.cancelStall(context);
    }

    default public boolean mustTickWhileDisabled() {
        return false;
    }

    default public void dropItem(MovementContext context, class_1799 stack) {
        class_1799 remainder;
        if (((Boolean)AllConfigs.server().kinetics.moveItemsToStorage.get()).booleanValue()) {
            try (Transaction t = TransferUtil.getTransaction();){
                long inserted = context.contraption.getStorage().getAllItems().insert((Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)t);
                remainder = stack.method_7972();
                remainder.method_7934((int)inserted);
                t.commit();
            }
        } else {
            remainder = stack;
        }
        if (remainder.method_7960()) {
            return;
        }
        class_243 vec = context.position;
        if (vec == null) {
            return;
        }
        class_1542 itemEntity = new class_1542(context.world, vec.field_1352, vec.field_1351, vec.field_1350, remainder);
        itemEntity.method_18799(context.motion.method_1031(0.0, 0.5, 0.0).method_1021((double)(context.world.field_9229.method_43057() * 0.3f)));
        context.world.method_8649((class_1297)itemEntity);
    }

    default public void onSpeedChanged(MovementContext context, class_243 oldMotion, class_243 motion) {
    }

    default public void stopMoving(MovementContext context) {
    }

    default public void cancelStall(MovementContext context) {
        context.stall = false;
    }

    default public void writeExtraData(MovementContext context) {
    }

    default public boolean disableBlockEntityRendering() {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    default public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, class_4597 buffer) {
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    default public ActorVisual createVisual(VisualizationContext visualizationContext, VirtualRenderWorld simulationWorld, MovementContext movementContext) {
        return null;
    }
}

